/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.sfp.topology;

import com.ibm.hsc.common.util.Crypt;
import com.ibm.hsc.sfp.topology.NetworkTopologyConstants;
import com.ibm.hsc.sfp.topology.NetworkTopologyEvent;
import com.ibm.hsc.sfp.topology.NetworkTopologyListener;
import com.ibm.hsc.sfp.topology.NetworkTopologyNode;
import com.ibm.hsc.sfp.topology.NetworkTopologyParser;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class NetworkTopology
implements Serializable,
NetworkTopologyConstants {
    private static final String TRACE_MASKT = "JSNTOPOT";
    private static final String TRACE_MASKF = "JSNTOPOF";
    private static final String TRACE_MASKD = "JSNTOPOD";
    private static final String TEMP_DIR = "/tmp/";
    private static final String OS_MOVE_CMD = "/bin/mv";
    private static final String OS_MOVE_CMD_OPTIONS = "-f";
    private static final String HSC_DO_CMD_EXECUTABLE = "/opt/hsc/bin/hscdc";
    private static final String IFCONFIG_CMD = "/sbin/ifconfig";
    private static final String ETHTOOL_CMD = "/usr/sbin/ethtool";
    private static final String HOSTNAME_CMD = "/bin/hostname";
    private static final String LSHMC_CMD = "/opt/hsc/bin/lshmc";
    private static final String LSHMC_OPTIONS = "-v";
    private static final String FACILITY_MANAGED_SYS_0 = "managedSystem0MTMS";
    private static final String FACILITY_MANAGED_SYS_1 = "managedSystem1MTMS";
    private static final String SEPARATOR = ":";
    private static final String LIST_RMC_RESOURCES_CMD = "/usr/bin/lsrsrc -D : ";
    private static final String LIST_FACILITIES_CMD = "/usr/bin/lsrsrc -D : IBM.EssStorageFacility storageFacilityMTMS managedSystem0MTMS managedSystem1MTMS";
    private static final String LIST_MANAGED_NODES_CMD = "/usr/bin/lsrsrc -D : IBM.ManagedNode UniversalId LParID HWModel HWSerialNum Hostname ConnectivityIPAddrs";
    private static final String LIST_NETWORK_INTERFACES_CMD = "/usr/bin/lsrsrc -D : IBM.MNNetworkInterface UniversalId IPAddress Status";
    private static final String LSSYSCFG_CMD = "/opt/hsc/bin/lssyscfg";
    private static final String LIST_MANAGED_SYS_OPTIONS = "-r sys -F name:type_model:serial_num:ipaddr:state";
    private static final String LIST_LPAR_OPTIONS = "-m";
    private static final String LIST_FRAME_OPTIONS = "-r frame -F name:ipaddr_a:ipaddr_b:type_model:serial_num:state";
    private static final String LIST_LPAR_SUFFIX = " -r lpar -F name:lpar_id:state";
    private static final String PING_CMD = "/bin/ping ";
    private static final int PING_DISCOVERY_TIMEOUT = 3;
    private static final int PING_DISCOVERY_PACKETS = 1;
    private static final String ARP_CMD = "/sbin/arp -n -e -i ";
    private static final String FSP_LOCATION_PREFIX = "U7879.00";
    private static final String FSP_LOCATION_SUFFIX = "-P1-C8";
    private static final String FSP_ENCLOSURE_NUMBER = "1";
    private static final String CEC_BUNDLE_NAME = "com.ibm.hsc.common.bundles.CECBundle";
    private static ResourceBundle US_CEC_BUNDLE = null;
    private static HashMap CEC_BUNDLE_MAP = null;
    private NetworkTopologyNode rootTopologyNode = null;
    private long timestamp = -1L;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$fcs$MachineId;

    public static void main(String[] stringArray) {
        try {
            if (stringArray == null || stringArray.length == 0) {
                NetworkTopology networkTopology = NetworkTopology.getCurrentTopology(new NetworkTopologyListener(){

                    public void topologyChanged(NetworkTopologyEvent networkTopologyEvent) {
                        System.out.println("topologyChanged() event id is " + networkTopologyEvent.getEventId());
                    }
                });
                System.out.println(networkTopology);
                NetworkTopology.saveTopology(networkTopology);
            } else if (stringArray[0].trim().equals("LOAD")) {
                NetworkTopology networkTopology = NetworkTopology.getSavedTopology();
                System.out.println(networkTopology);
                NetworkTopology.saveTopology(networkTopology);
            } else {
                NetworkTopology networkTopology = new NetworkTopology(stringArray[0]);
                System.out.println(networkTopology);
                NetworkTopology.saveTopology(networkTopology);
            }
        }
        catch (MalformedXMLException malformedXMLException) {
            malformedXMLException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static NetworkTopology getCurrentTopology() {
        return NetworkTopology.getCurrentTopology(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkTopology getCurrentTopology(NetworkTopologyListener networkTopologyListener) {
        NetworkTopology networkTopology;
        block7: {
            Trace.trace((String)TRACE_MASKT, (Object)("-> NetworkTopology.getCurrentTopology() listener is " + networkTopologyListener));
            networkTopology = new NetworkTopology();
            EventThread eventThread = null;
            try {
                if (networkTopologyListener != null) {
                    eventThread = new EventThread(networkTopologyListener);
                    eventThread.start();
                }
                networkTopology.discoverTopology(eventThread);
                Object var4_3 = null;
                if (eventThread == null) break block7;
                eventThread.stopRunning();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (eventThread != null) {
                    eventThread.stopRunning();
                    try {
                        eventThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                eventThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- NetworkTopology.getCurrentTopology()");
        return networkTopology;
    }

    public static synchronized NetworkTopology getSavedTopology() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.getSavedTopology()");
        NetworkTopology networkTopology = null;
        try {
            networkTopology = new NetworkTopology("/opt/hsc/data/topology/saved_topology.xml");
        }
        catch (MalformedXMLException malformedXMLException) {
            Trace.trace((String)TRACE_MASKD, (Object)("NetworkTopology.getSavedTopology() returning null -- MalformedXMLException " + (Object)((Object)malformedXMLException)));
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- NetworkTopology.getSavedTopology()");
        return networkTopology;
    }

    public static synchronized void saveTopology(NetworkTopology networkTopology) throws IOException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.saveTopology()");
        File file = null;
        int n = -1;
        try {
            file = File.createTempFile(TRACE_MASKT, null, new File(TEMP_DIR));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(networkTopology.toXML());
            bufferedWriter.close();
            n = NetworkTopology.executeCommand("/opt/hsc/bin/hscdc " + Crypt.encrypt(OS_MOVE_CMD) + " " + OS_MOVE_CMD_OPTIONS + " " + file.getCanonicalPath() + " " + "/opt/hsc/data/topology/saved_topology.xml", null);
            networkTopology.setLastSavedTimestamp(new File("/opt/hsc/data/topology/saved_topology.xml").lastModified());
        }
        catch (IOException iOException) {
            Trace.trace((String)TRACE_MASKD, (Object)("NetworkTopology.saveTopology() IOException caught saving XML: " + iOException));
            throw iOException;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        if (n != 0) {
            Trace.trace((String)TRACE_MASKD, (Object)("NetworkTopology.saveTopology() bad return code moving XML from temp dir: " + n));
            throw new IOException("NetworkTopology.saveTopology() bad return code moving XML from temp dir: " + n);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- NetworkTopology.saveTopology()");
    }

    NetworkTopology() {
    }

    public NetworkTopology(String string) throws MalformedXMLException {
        File file = new File(string);
        NetworkTopologyParser.parseXML(file, this);
        this.setLastSavedTimestamp(file.lastModified());
    }

    public NetworkTopologyNode getRoot() {
        return this.rootTopologyNode;
    }

    void setRoot(NetworkTopologyNode networkTopologyNode) {
        this.rootTopologyNode = networkTopologyNode;
    }

    private void discoverTopology(EventThread eventThread) {
        int n;
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.discoverTopology()");
        NetworkTopologyNode networkTopologyNode = NetworkTopology.createLocalHMCNode();
        if (eventThread != null) {
            eventThread.add(new NetworkTopologyEvent(this, 1));
        }
        NetworkTopologyNode[] networkTopologyNodeArray = NetworkTopology.createEthernetPortNodes();
        if (eventThread != null) {
            eventThread.add(new NetworkTopologyEvent(this, 2));
        }
        NetworkTopologyNode[] networkTopologyNodeArray2 = NetworkTopology.createFacilities();
        if (eventThread != null && networkTopologyNodeArray2.length > 0) {
            eventThread.add(new NetworkTopologyEvent(this, 3));
        }
        NetworkTopologyNode[] networkTopologyNodeArray3 = NetworkTopology.createManagedSystems();
        if (eventThread != null) {
            eventThread.add(new NetworkTopologyEvent(this, 4));
        }
        NetworkTopology.createLPARs(networkTopologyNodeArray3, networkTopologyNodeArray);
        NetworkTopology.createBPAs(networkTopologyNodeArray);
        if (eventThread != null) {
            eventThread.add(new NetworkTopologyEvent(this, 5));
        }
        for (n = 0; n < networkTopologyNodeArray.length; ++n) {
            networkTopologyNode.addChild(networkTopologyNodeArray[n]);
        }
        if (networkTopologyNodeArray2.length > 0) {
            for (n = 0; n < networkTopologyNodeArray2.length; ++n) {
                String string;
                NetworkTopologyNode networkTopologyNode2;
                int n2;
                String string2;
                int n3;
                NetworkTopologyNode networkTopologyNode3 = networkTopologyNodeArray2[n];
                for (int i = 0; i < networkTopologyNodeArray3.length; ++i) {
                    NetworkTopologyNode networkTopologyNode4 = networkTopologyNodeArray3[i];
                    String string3 = networkTopologyNode4.getAttribute("mtms");
                    if (!string3.equals((String)networkTopologyNode3.getUserData(FACILITY_MANAGED_SYS_0)) && !string3.equals((String)networkTopologyNode3.getUserData(FACILITY_MANAGED_SYS_1))) continue;
                    networkTopologyNode3.addChild(networkTopologyNode4);
                }
                if (networkTopologyNode3.isTerminal()) continue;
                NetworkTopologyNode[] networkTopologyNodeArray4 = networkTopologyNode3.getChildren();
                boolean bl = false;
                for (n3 = 0; n3 < networkTopologyNodeArray4.length && !bl; ++n3) {
                    string2 = (String)networkTopologyNodeArray4[n3].getUserData("ip_address");
                    if (string2 == null) continue;
                    for (n2 = 0; n2 < networkTopologyNodeArray.length && !bl; ++n2) {
                        networkTopologyNode2 = networkTopologyNodeArray[n2];
                        string = networkTopologyNode2.getAttribute("interface");
                        if (string == null || string.length() <= 0 || !NetworkTopology.ping(string2, 3, 1, string, null)) continue;
                        networkTopologyNode2.addChild(networkTopologyNode3);
                        bl = true;
                    }
                }
                if (bl) continue;
                for (n3 = 0; n3 < networkTopologyNodeArray4.length && !bl; ++n3) {
                    string2 = (String)networkTopologyNodeArray4[n3].getUserData("ip_address");
                    if (string2 == null) continue;
                    for (n2 = 0; n2 < networkTopologyNodeArray.length && !bl; ++n2) {
                        networkTopologyNode2 = networkTopologyNodeArray[n2];
                        string = networkTopologyNode2.getAttribute("interface");
                        if (string == null || string.length() <= 0 || !NetworkTopology.maskAddress(string, string2)) continue;
                        networkTopologyNode2.addChild(networkTopologyNode3);
                        bl = true;
                    }
                }
            }
        } else {
            for (n = 0; n < networkTopologyNodeArray3.length; ++n) {
                String string;
                NetworkTopologyNode networkTopologyNode5;
                int n4;
                NetworkTopologyNode networkTopologyNode6 = networkTopologyNodeArray3[n];
                String string4 = (String)networkTopologyNode6.getUserData("ip_address");
                if (string4 == null) continue;
                boolean bl = false;
                for (n4 = 0; n4 < networkTopologyNodeArray.length && !bl; ++n4) {
                    networkTopologyNode5 = networkTopologyNodeArray[n4];
                    string = networkTopologyNode5.getAttribute("interface");
                    if (string == null || string.length() <= 0 || !NetworkTopology.ping(string4, 3, 1, string, null)) continue;
                    networkTopologyNode5.addChild(networkTopologyNode6);
                    bl = true;
                }
                if (bl) continue;
                for (n4 = 0; n4 < networkTopologyNodeArray.length && !bl; ++n4) {
                    networkTopologyNode5 = networkTopologyNodeArray[n4];
                    string = networkTopologyNode5.getAttribute("interface");
                    if (string == null || string.length() <= 0 || !NetworkTopology.maskAddress(string, string4)) continue;
                    networkTopologyNode5.addChild(networkTopologyNode6);
                    bl = true;
                }
            }
        }
        NetworkTopology.createRemoteHMCs(networkTopologyNodeArray, networkTopologyNode.getAttribute("hostname"));
        if (eventThread != null) {
            eventThread.add(new NetworkTopologyEvent(this, 6));
        }
        this.setRoot(networkTopologyNode);
        if (eventThread != null) {
            eventThread.add(new NetworkTopologyEvent(this, 10));
        }
        CumulativeStatus cumulativeStatus = new CumulativeStatus();
        cumulativeStatus.collectChildrenStatus(networkTopologyNode, true);
        networkTopologyNode.setAttribute("status", cumulativeStatus.getCumulativeStatusString());
        if (eventThread != null) {
            eventThread.add(new NetworkTopologyEvent(this, 20));
        }
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.discoverTopology()");
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>");
        stringBuffer.append('\n');
        stringBuffer.append("<!DOCTYPE local_hmc SYSTEM \"");
        stringBuffer.append("/opt/hsc/data/topology/NetworkTopology.dtd");
        stringBuffer.append("\">\n");
        if (this.getRoot() != null) {
            stringBuffer.append(this.getRoot().toXML());
        }
        return stringBuffer.toString();
    }

    private void setLastSavedTimestamp(long l) {
        this.timestamp = l;
    }

    public long getLastSavedTimestamp() {
        return this.timestamp;
    }

    static int executeCommand(String string, StringBuffer stringBuffer) throws IOException {
        return NetworkTopology.executeCommand(string, stringBuffer, null);
    }

    static int executeCommand(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IOException {
        BufferedReader bufferedReader;
        int n;
        Process process = null;
        try {
            Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.executeCommand() issuing command: " + string));
            process = Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.executeCommand() IOException: " + iOException));
            throw iOException;
        }
        int n2 = -1;
        try {
            n2 = process.waitFor();
            Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.executeCommand() The command, " + string + ", returned with an rc of " + n2 + "."));
        }
        catch (InterruptedException interruptedException) {
            Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.executeCommand() InterruptedException: " + interruptedException));
            throw new IOException("The command, " + string + ", was interrupted.");
        }
        if (stringBuffer != null) {
            n = stringBuffer.length();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                int n3 = 0;
                while ((n3 = bufferedReader.read()) != -1) {
                    stringBuffer.append((char)n3);
                }
            }
            catch (IOException iOException) {
                Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.executeCommand() IOException reading stdout: " + iOException));
            }
            stringBuffer.delete(0, n);
        }
        if (stringBuffer2 != null) {
            n = stringBuffer2.length();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            try {
                int n4 = 0;
                while ((n4 = bufferedReader.read()) != -1) {
                    stringBuffer2.append((char)n4);
                }
            }
            catch (IOException iOException) {
                Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.executeCommand() IOException reading stderr: " + iOException));
            }
            stringBuffer2.delete(0, n);
        }
        return n2;
    }

    private static NetworkTopologyNode createLocalHMCNode() {
        CharSequence charSequence;
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.createLocalHMCNode()");
        NetworkTopologyNode networkTopologyNode = new NetworkTopologyNode("local_hmc");
        StringBuffer stringBuffer = new StringBuffer("unknown");
        try {
            NetworkTopology.executeCommand(HOSTNAME_CMD, stringBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = stringBuffer.toString().trim();
        networkTopologyNode.setAttribute("hostname", string);
        String string2 = null;
        String string3 = null;
        try {
            charSequence = new StringBuffer();
            int n = NetworkTopology.executeCommand("/opt/hsc/bin/hscdc " + Crypt.encrypt(LSHMC_CMD) + " " + LSHMC_OPTIONS, (StringBuffer)charSequence);
            if (n == 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(((StringBuffer)charSequence).toString());
                while ((string2 == null || string3 == null) && stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (string2 == null && string4.startsWith("*TM") && stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        continue;
                    }
                    if (string3 != null || !string4.startsWith("*SE") || !stringTokenizer.hasMoreTokens()) continue;
                    string3 = stringTokenizer.nextToken();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        charSequence = NetworkTopology.buildMTMS(string2, string3);
        networkTopologyNode.setAttribute("mtms", (String)charSequence);
        networkTopologyNode.setAttribute("status", "unknown");
        Trace.trace((String)TRACE_MASKT, (Object)("<- NetworkTopology.createLocalHMCNode() for " + string));
        return networkTopologyNode;
    }

    private static NetworkTopologyNode[] createEthernetPortNodes() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.createEthernetPortNodes()");
        ArrayList<NetworkTopologyNode> arrayList = new ArrayList<NetworkTopologyNode>();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            NetworkTopology.executeCommand(IFCONFIG_CMD, stringBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (!string.startsWith("eth")) continue;
            NetworkTopologyNode networkTopologyNode = new NetworkTopologyNode("ethernet_port");
            StringTokenizer stringTokenizer2 = new StringTokenizer(string);
            String string2 = stringTokenizer2.nextToken();
            networkTopologyNode.setAttribute("interface", string2);
            string = stringTokenizer.nextToken();
            String string3 = "unknown";
            int n = string.indexOf("inet addr:");
            if (n > -1 && (string3 = string.substring(n + "inet addr:".length())).indexOf(" ") > 0) {
                string3 = string3.substring(0, string3.indexOf(" ")).trim();
            }
            networkTopologyNode.setAttribute("ip_address", string3);
            StringBuffer stringBuffer2 = new StringBuffer("unknown");
            try {
                NetworkTopology.executeCommand("/opt/hsc/bin/hscdc " + Crypt.encrypt(ETHTOOL_CMD) + " " + string2, stringBuffer2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string4 = stringBuffer2.toString();
            networkTopologyNode.setAttribute("link_details", string4);
            String string5 = "unknown";
            n = string4.indexOf("Speed:");
            if (n > -1) {
                string5 = string4.substring(n + "Speed:".length());
                if ((n = string5.indexOf("\n")) > 0) {
                    string5 = string5.substring(0, n);
                }
                string5 = string5.trim();
            }
            networkTopologyNode.setAttribute("link_speed", string5);
            String string6 = "no_link";
            String string7 = "no";
            n = string4.indexOf("Link detected:");
            if (n > -1) {
                string7 = string4.substring(n + "Link detected:".length());
                if ((n = string7.indexOf("\n")) > 0) {
                    string7 = string7.substring(0, n);
                }
                string7 = string7.trim();
            }
            if (string7.equalsIgnoreCase("yes")) {
                String string8 = "";
                n = string4.indexOf("Duplex:");
                if (n > -1) {
                    string8 = string4.substring(n + "Duplex:".length());
                    if ((n = string8.indexOf("\n")) > 0) {
                        string8 = string8.substring(0, n);
                    }
                    string8 = string8.trim();
                }
                string6 = string8.equalsIgnoreCase("full") ? "full_duplex_link" : "half_duplex_link";
            }
            networkTopologyNode.setAttribute("status", string6);
            Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createEthernetPortNodes() adding port: " + string2));
            arrayList.add(networkTopologyNode);
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- NetworkTopology.createEthernetPortNodes() returning " + arrayList.size() + " ports"));
        return arrayList.toArray(new NetworkTopologyNode[arrayList.size()]);
    }

    private static NetworkTopologyNode[] createFacilities() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.createFacilities()");
        ArrayList<NetworkTopologyNode> arrayList = new ArrayList<NetworkTopologyNode>();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            NetworkTopology.executeCommand(LIST_FACILITIES_CMD, stringBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    String string;
                    String string2 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, SEPARATOR);
                    if (!stringTokenizer2.hasMoreTokens() || (string = NetworkTopology.trimQuotes(stringTokenizer2.nextToken())).length() <= 0) continue;
                    String string3 = "????-???*???????";
                    String string4 = "????-???*???????";
                    if (stringTokenizer2.hasMoreTokens()) {
                        string3 = NetworkTopology.trimQuotes(stringTokenizer2.nextToken());
                        if (stringTokenizer2.hasMoreTokens()) {
                            string4 = NetworkTopology.trimQuotes(stringTokenizer2.nextToken());
                        }
                    }
                    NetworkTopologyNode networkTopologyNode = new NetworkTopologyNode("facility");
                    networkTopologyNode.setAttribute("mtms", string);
                    networkTopologyNode.setUserData(FACILITY_MANAGED_SYS_0, string3);
                    networkTopologyNode.setUserData(FACILITY_MANAGED_SYS_1, string4);
                    Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createFacilities() adding facility: " + string));
                    arrayList.add(networkTopologyNode);
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- NetworkTopology.createFacilities() returning " + arrayList.size() + " facilities"));
        return arrayList.toArray(new NetworkTopologyNode[arrayList.size()]);
    }

    private static NetworkTopologyNode[] createManagedSystems() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.createManagedSystems()");
        ArrayList<NetworkTopologyNode> arrayList = new ArrayList<NetworkTopologyNode>();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            NetworkTopology.executeCommand("/opt/hsc/bin/hscdc " + Crypt.encrypt(LSSYSCFG_CMD) + " " + LIST_MANAGED_SYS_OPTIONS, stringBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = stringBuffer.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(SEPARATOR) <= -1) continue;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = "unknown";
            String string7 = "unknown";
            String string8 = null;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, SEPARATOR);
            if (stringTokenizer2.hasMoreTokens()) {
                string3 = stringTokenizer2.nextToken();
                if (stringTokenizer2.hasMoreTokens()) {
                    string4 = stringTokenizer2.nextToken();
                    if (stringTokenizer2.hasMoreTokens()) {
                        string5 = stringTokenizer2.nextToken();
                        if (stringTokenizer2.hasMoreTokens()) {
                            string6 = stringTokenizer2.nextToken();
                            if (stringTokenizer2.hasMoreTokens()) {
                                string7 = stringTokenizer2.nextToken().trim();
                                string8 = NetworkTopology.convertState(string7);
                            }
                        }
                    }
                }
            }
            NetworkTopologyNode networkTopologyNode = new NetworkTopologyNode("managed_system");
            NetworkTopologyNode networkTopologyNode2 = new NetworkTopologyNode("fsp");
            networkTopologyNode.addChild(networkTopologyNode2);
            String string9 = NetworkTopology.buildMTMS(string4, string5);
            networkTopologyNode.setAttribute("mtms", string9);
            networkTopologyNode2.setAttribute("mtms", string9);
            networkTopologyNode.setAttribute("status", string7);
            if (string8 != null) {
                networkTopologyNode.setAttribute("status_key", string8);
                networkTopologyNode.setAttribute("status_bundle", CEC_BUNDLE_NAME);
            }
            networkTopologyNode.setUserData("hostname", string3);
            networkTopologyNode2.setAttribute("hostname", string3);
            networkTopologyNode.setUserData("ip_address", string6);
            networkTopologyNode2.setAttribute("ip_address", string6);
            networkTopologyNode2.setAttribute("status", NetworkTopology.ping(string6, 3, 1, null, null) ? "online" : "offline");
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(FSP_LOCATION_PREFIX);
            stringBuffer2.append(FSP_ENCLOSURE_NUMBER);
            stringBuffer2.append("-");
            stringBuffer2.append(string5 == null ? "???????" : string5);
            stringBuffer2.append(FSP_LOCATION_SUFFIX);
            networkTopologyNode2.setAttribute("location_code", stringBuffer2.toString());
            Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createManagedSystems() adding managed system: " + string3 + " " + string6));
            arrayList.add(networkTopologyNode);
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- NetworkTopology.createManagedSystems() returning " + arrayList.size() + " managed systems"));
        return arrayList.toArray(new NetworkTopologyNode[arrayList.size()]);
    }

    private static NetworkTopologyNode[] createLPARs(NetworkTopologyNode[] networkTopologyNodeArray, NetworkTopologyNode[] networkTopologyNodeArray2) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.createLPARs()");
        HashMap hashMap = null;
        ArrayList<NetworkTopologyNode> arrayList = new ArrayList<NetworkTopologyNode>();
        for (int i = 0; i < networkTopologyNodeArray.length; ++i) {
            NetworkTopologyNode networkTopologyNode = networkTopologyNodeArray[i];
            String string = (String)networkTopologyNode.getUserData("hostname");
            StringBuffer stringBuffer = new StringBuffer();
            try {
                NetworkTopology.executeCommand("/opt/hsc/bin/hscdc " + Crypt.encrypt(LSSYSCFG_CMD) + " " + LIST_LPAR_OPTIONS + " " + string + " " + LIST_LPAR_SUFFIX, stringBuffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string2 = stringBuffer.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                NetworkTopologyNode networkTopologyNode2;
                String string3;
                int n;
                HostInfo hostInfo;
                String string4 = stringTokenizer.nextToken();
                if (string4.indexOf(SEPARATOR) <= -1) continue;
                String string5 = "unknown";
                String string6 = "unknown";
                String string7 = "unknown";
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, SEPARATOR);
                if (stringTokenizer2.hasMoreTokens()) {
                    string5 = stringTokenizer2.nextToken();
                    if (stringTokenizer2.hasMoreTokens()) {
                        string6 = stringTokenizer2.nextToken();
                        if (stringTokenizer2.hasMoreTokens()) {
                            string7 = stringTokenizer2.nextToken().trim();
                        }
                    }
                }
                NetworkTopologyNode networkTopologyNode3 = new NetworkTopologyNode("lpar");
                networkTopologyNode.addChild(networkTopologyNode3);
                networkTopologyNode3.setAttribute("lpar_id", string6);
                networkTopologyNode3.setAttribute("lpar_name", string5);
                String string8 = networkTopologyNode.getAttribute("mtms");
                networkTopologyNode3.setAttribute("mtms", string8);
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(string8);
                stringBuffer2.append("-V");
                stringBuffer2.append(string6);
                networkTopologyNode3.setAttribute("location_code", stringBuffer2.toString());
                if (hashMap == null) {
                    hashMap = NetworkTopology.mapLPARAddresses();
                }
                String string9 = (hostInfo = (HostInfo)hashMap.get(string6 + "*" + string8)) == null ? string5 : hostInfo.hostName;
                networkTopologyNode3.setAttribute("hostname", string9);
                boolean bl = false;
                if (hostInfo != null && hostInfo.numAddresses() > 0) {
                    for (n = 0; n < hostInfo.numAddresses(); ++n) {
                        int n2;
                        string3 = hostInfo.getAddress(n);
                        networkTopologyNode2 = null;
                        boolean bl2 = false;
                        for (n2 = 0; n2 < networkTopologyNodeArray2.length; ++n2) {
                            String string10 = networkTopologyNodeArray2[n2].getAttribute("interface");
                            bl2 = NetworkTopology.ping(string3, 3, 1, string10, null);
                            if (!bl2) continue;
                            networkTopologyNode2 = networkTopologyNodeArray2[n2];
                            break;
                        }
                        if (networkTopologyNode2 == null) {
                            for (n2 = 0; n2 < networkTopologyNodeArray2.length; ++n2) {
                                if (!NetworkTopology.maskAddress(string3, networkTopologyNodeArray2[n2].getAttribute("ip_address"))) continue;
                                networkTopologyNode2 = networkTopologyNodeArray2[n2];
                                break;
                            }
                        }
                        if (networkTopologyNode2 == null) continue;
                        NetworkTopologyNode networkTopologyNode4 = (NetworkTopologyNode)networkTopologyNode3.clone();
                        networkTopologyNode4.setAttribute("ip_address", string3);
                        boolean bl3 = hostInfo.getStatus(string3);
                        String string11 = null;
                        string11 = bl3 && bl2 ? "active" : (bl3 ? "offline" : (bl2 ? "on" : "off"));
                        networkTopologyNode4.setAttribute("connectivity_status", string11);
                        networkTopologyNode2.addChild(networkTopologyNode4);
                        bl = true;
                        Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createLPARs() adding LPAR under port: " + string5 + " " + string6 + "(" + stringBuffer2.toString() + ")"));
                        arrayList.add(networkTopologyNode4);
                    }
                }
                if (!bl) {
                    for (n = 0; n < networkTopologyNodeArray2.length; ++n) {
                        string3 = networkTopologyNodeArray2[n].getAttribute("interface");
                        if (!NetworkTopology.ping(string9, 3, 1, string3, null)) continue;
                        networkTopologyNode2 = (NetworkTopologyNode)networkTopologyNode3.clone();
                        networkTopologyNode2.setAttribute("connectivity_status", "on");
                        networkTopologyNodeArray2[n].addChild(networkTopologyNode2);
                        Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createLPARs() adding LPAR under port: " + string5 + " " + string6 + "(" + stringBuffer2.toString() + ")"));
                        arrayList.add(networkTopologyNode2);
                        break;
                    }
                }
                networkTopologyNode3.setAttribute("status", string7);
                String string12 = NetworkTopology.convertState(string7);
                if (string12 != null) {
                    networkTopologyNode3.setAttribute("status_bundle", CEC_BUNDLE_NAME);
                    networkTopologyNode3.setAttribute("status_key", string12);
                }
                Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createLPARs() adding LPAR under managed system: " + string5 + " " + string6 + "(" + stringBuffer2.toString() + ")"));
                arrayList.add(networkTopologyNode3);
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- NetworkTopology.createLPARs() returning " + arrayList.size() + " lpars"));
        return arrayList.toArray(new NetworkTopologyNode[arrayList.size()]);
    }

    private static boolean maskAddress(String string, String string2) {
        boolean bl = false;
        if (string != null && string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string3 = null;
            if (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    stringTokenizer = new StringTokenizer(string2, ".");
                    if (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken();
                            bl = string4.equals(string6) && string5.equals(string3);
                        }
                    }
                }
            }
        }
        return bl;
    }

    private static HashMap mapLPARAddresses() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.mapLPARAddresses()");
        HashMap<Object, HostInfo> hashMap = new HashMap<Object, HostInfo>();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            NetworkTopology.executeCommand(LIST_MANAGED_NODES_CMD, stringBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    Object object;
                    String string = stringTokenizer.nextToken();
                    HostInfo hostInfo = new HostInfo();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string, SEPARATOR);
                    if (!stringTokenizer2.hasMoreTokens()) continue;
                    hostInfo.id = NetworkTopology.trimQuotes(stringTokenizer2.nextToken());
                    if (!stringTokenizer2.hasMoreTokens()) continue;
                    String string2 = NetworkTopology.trimQuotes(stringTokenizer2.nextToken());
                    if (!stringTokenizer2.hasMoreTokens()) continue;
                    String string3 = NetworkTopology.trimQuotes(stringTokenizer2.nextToken());
                    if (!stringTokenizer2.hasMoreTokens()) continue;
                    String string4 = NetworkTopology.trimQuotes(stringTokenizer2.nextToken());
                    String string5 = NetworkTopology.buildMTMS(string3, string4);
                    if (!stringTokenizer2.hasMoreTokens()) continue;
                    hostInfo.hostName = NetworkTopology.trimQuotes(stringTokenizer2.nextToken());
                    if (stringTokenizer2.hasMoreTokens()) {
                        object = new StringTokenizer(NetworkTopology.trimBraces(stringTokenizer2.nextToken()), ",");
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            hostInfo.addAddress(NetworkTopology.trimQuotes(((StringTokenizer)object).nextToken()));
                        }
                    }
                    object = string2 + "*" + string5;
                    hashMap.put(object, hostInfo);
                    Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.mapLPARAddresses() mapped " + (String)object + " to " + hostInfo.hostName + " and " + hostInfo.ipAddrs.size() + " ip addresses"));
                }
            }
        }
        NetworkTopology.getRMCStatuses(hashMap);
        Trace.trace((String)TRACE_MASKT, (Object)("<- NetworkTopology.mapLPARAddresses() returning map with " + hashMap.size() + " entries."));
        return hashMap;
    }

    private static void getRMCStatuses(HashMap hashMap) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.getRMCStatuses()");
        StringBuffer stringBuffer = new StringBuffer();
        try {
            NetworkTopology.executeCommand(LIST_NETWORK_INTERFACES_CMD, stringBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string, SEPARATOR);
                    if (!stringTokenizer2.hasMoreTokens()) continue;
                    String string2 = NetworkTopology.trimQuotes(stringTokenizer2.nextToken());
                    HostInfo hostInfo = null;
                    Object object = hashMap.values().iterator();
                    while (object.hasNext()) {
                        hostInfo = (HostInfo)object.next();
                        if (hostInfo.id.equals(string2)) break;
                        hostInfo = null;
                    }
                    if (hostInfo == null || !stringTokenizer2.hasMoreTokens()) continue;
                    object = NetworkTopology.trimQuotes(stringTokenizer2.nextToken());
                    if (!stringTokenizer2.hasMoreTokens()) continue;
                    String string3 = NetworkTopology.trimQuotes(stringTokenizer2.nextToken());
                    hostInfo.setStatus((String)object, string3);
                    Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.getRMCStatuses() added status for " + (String)object + " of " + string3));
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- NetworkTopology.getRMCStatuses()");
    }

    private static void createRemoteHMCs(NetworkTopologyNode[] networkTopologyNodeArray, String string) {
        Object object;
        Object object2;
        String string2;
        Object object3;
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.createRemoteHMCs()");
        ArrayList[] arrayListArray = new ArrayList[networkTopologyNodeArray.length];
        FcsServer fcsServer = FcsServer.getFcsServer();
        if (fcsServer == null) {
            Trace.trace((String)TRACE_MASKF, (Object)"NetworkTopology.createRemoteHMCs() could not get FcsServer");
        } else {
            Method method = null;
            try {
                method = (class$com$ibm$hwmca$fw$fcs$MachineId == null ? (class$com$ibm$hwmca$fw$fcs$MachineId = NetworkTopology.class$("com.ibm.hwmca.fw.fcs.MachineId")) : class$com$ibm$hwmca$fw$fcs$MachineId).getMethod("getMacAddresses", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object3 = fcsServer.getMachineList();
            Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createRemoteHMCs() got " + object3.size() + " remote HMCs from FCS"));
            for (int i = 0; i < networkTopologyNodeArray.length; ++i) {
                arrayListArray[i] = new ArrayList();
                string2 = networkTopologyNodeArray[i].getAttribute("interface");
                object2 = networkTopologyNodeArray[i].getAttribute("ip_address");
                object = object3.iterator();
                while (object.hasNext()) {
                    MachineId machineId = (MachineId)object.next();
                    InetAddress[] inetAddressArray = machineId.getNicAddresses();
                    String string3 = machineId.getName();
                    if (inetAddressArray == null || inetAddressArray.length == 0 || string3 == null || string3.equals(string)) continue;
                    boolean[] blArray = machineId.getPublicNetworkIndicators();
                    String[] stringArray = null;
                    if (method != null) {
                        try {
                            stringArray = (String[])method.invoke((Object)machineId, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String string4 = machineId.getMachineType();
                    String string5 = machineId.getMachineModel();
                    String string6 = machineId.getMachineSerial();
                    String string7 = NetworkTopology.buildMTMS(string4, string5, string6);
                    boolean bl = false;
                    for (int j = 0; j < inetAddressArray.length && !bl; ++j) {
                        String string8 = inetAddressArray[j].getHostAddress();
                        if (arrayListArray[i].contains(string8) || string8.equals(object2) || !NetworkTopology.ping(string8, 3, 1, string2, null)) continue;
                        NetworkTopologyNode networkTopologyNode = new NetworkTopologyNode("remote_hmc");
                        networkTopologyNode.setAttribute("ip_address", string8);
                        networkTopologyNode.setAttribute("status", "online");
                        boolean bl2 = blArray[j];
                        if (bl2) {
                            networkTopologyNode.setAttribute("mtms", string7);
                            networkTopologyNode.setAttribute("hostname", string3);
                            networkTopologyNodeArray[i].addChild(networkTopologyNode);
                            arrayListArray[i].add(string8);
                            Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createRemoteHMCs() adding w/ping mapping public remote HMC: " + string3 + " at " + string8 + " under " + string2));
                            bl = true;
                            continue;
                        }
                        if (stringArray == null || stringArray[j] == null || stringArray[j].length() == 0) {
                            String string9 = null;
                            try {
                                int n;
                                string9 = InetAddress.getByName(string8).getCanonicalHostName();
                                if (string9 != null && !string9.equals(string8) && (n = string9.indexOf(".")) > 0) {
                                    string9 = string9.substring(0, n);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            networkTopologyNode.setAttribute("hostname", string9 == null ? string8 : string9);
                            networkTopologyNodeArray[i].addChild(networkTopologyNode);
                            arrayListArray[i].add(string8);
                            Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createRemoteHMCs() adding w/ping mapping private remote HMC: " + string8 + " under " + string2));
                            bl = true;
                            continue;
                        }
                        if (!NetworkTopology.macAddressesMatch(stringArray[j], string8, string2)) continue;
                        networkTopologyNode.setAttribute("mtms", string7);
                        networkTopologyNode.setAttribute("hostname", string3);
                        networkTopologyNodeArray[i].addChild(networkTopologyNode);
                        arrayListArray[i].add(string8);
                        Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createRemoteHMCs() adding w/ping mapping private remote HMC: " + string3 + " at " + string8 + " under " + string2));
                        bl = true;
                    }
                }
            }
        }
        for (int i = 0; i < networkTopologyNodeArray.length; ++i) {
            if (arrayListArray[i] != null && arrayListArray[i].size() != 0) continue;
            object3 = networkTopologyNodeArray[i].getAttribute("ip_address");
            String string10 = null;
            if (((String)object3).equals("172.16.0.1")) {
                string10 = "172.16.0.2";
            } else if (((String)object3).equals("172.16.0.2")) {
                string10 = "172.16.0.1";
            } else if (((String)object3).equals("172.17.0.1")) {
                string10 = "172.17.0.2";
            } else {
                if (!((String)object3).equals("172.17.0.2")) continue;
                string10 = "172.17.0.1";
            }
            string2 = networkTopologyNodeArray[i].getAttribute("interface");
            if (!NetworkTopology.ping(string10, 3, 1, string2, null)) continue;
            object2 = new NetworkTopologyNode("remote_hmc");
            ((NetworkTopologyNode)object2).setAttribute("ip_address", string10);
            ((NetworkTopologyNode)object2).setAttribute("status", "online");
            object = null;
            try {
                int n;
                object = InetAddress.getByName(string10).getCanonicalHostName();
                if (object != null && !((String)object).equals(string10) && (n = ((String)object).indexOf(".")) > 0) {
                    object = ((String)object).substring(0, n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((NetworkTopologyNode)object2).setAttribute("hostname", (String)(object == null ? string10 : object));
            networkTopologyNodeArray[i].addChild((NetworkTopologyNode)object2);
            Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createRemoteHMCs() adding w/ping mapping architected remote HMC: " + string10 + " under " + string2));
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- NetworkTopology.createRemoteHMCs()");
    }

    private static void createBPAs(NetworkTopologyNode[] networkTopologyNodeArray) {
        String string;
        String string2;
        Object object;
        Object object2;
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopology.createBPAs()");
        ArrayList<NetworkTopologyNode> arrayList = new ArrayList<NetworkTopologyNode>();
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        try {
            n = NetworkTopology.executeCommand("/opt/hsc/bin/hscdc " + Crypt.encrypt(LSSYSCFG_CMD) + " " + LIST_FRAME_OPTIONS, stringBuffer);
            if (n != 0) {
                Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createBPAs() non-zero return code from lssyscfg: " + n));
                stringBuffer.setLength(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            object2 = new StringTokenizer(stringTokenizer.nextToken(), SEPARATOR);
            if (((StringTokenizer)object2).countTokens() <= 5) continue;
            object = ((StringTokenizer)object2).nextToken();
            string2 = ((StringTokenizer)object2).nextToken();
            String string3 = ((StringTokenizer)object2).nextToken();
            String string4 = ((StringTokenizer)object2).nextToken();
            string = ((StringTokenizer)object2).nextToken();
            String string5 = ((StringTokenizer)object2).nextToken().trim();
            String string6 = NetworkTopology.convertState(string5);
            NetworkTopologyNode networkTopologyNode = new NetworkTopologyNode("bpa");
            String string7 = NetworkTopology.buildMTMS(string4, string);
            networkTopologyNode.setAttribute("mtms", string7);
            networkTopologyNode.setAttribute("hostname", (String)object);
            networkTopologyNode.setAttribute("status", string5);
            if (string6 != null) {
                networkTopologyNode.setAttribute("status_key", string6);
                networkTopologyNode.setAttribute("status_bundle", CEC_BUNDLE_NAME);
            }
            NetworkTopologyNode networkTopologyNode2 = (NetworkTopologyNode)networkTopologyNode.clone();
            networkTopologyNode.setAttribute("ip_address", string2);
            networkTopologyNode2.setAttribute("ip_address", string3);
            arrayList.add(networkTopologyNode);
            arrayList.add(networkTopologyNode2);
        }
        Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createBPAs() created " + arrayList.size() + " BPA nodes."));
        object2 = arrayList.iterator();
        block3: while (object2.hasNext()) {
            int n2;
            object = (NetworkTopologyNode)object2.next();
            string2 = ((NetworkTopologyNode)object).getAttribute("ip_address");
            boolean bl = false;
            for (n2 = 0; n2 < networkTopologyNodeArray.length; ++n2) {
                string = networkTopologyNodeArray[n2].getAttribute("interface");
                bl = NetworkTopology.ping(string2, 3, 1, string, null);
                if (!bl) continue;
                ((NetworkTopologyNode)object).setAttribute("connectivity_status", "online");
                networkTopologyNodeArray[n2].addChild((NetworkTopologyNode)object);
                Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createBPAs() mapping BPA " + string2 + " to " + string));
                break;
            }
            if (bl) continue;
            for (n2 = 0; n2 < networkTopologyNodeArray.length; ++n2) {
                if (!NetworkTopology.maskAddress(string2, networkTopologyNodeArray[n2].getAttribute("ip_address"))) continue;
                ((NetworkTopologyNode)object).setAttribute("connectivity_status", "offline");
                networkTopologyNodeArray[n2].addChild((NetworkTopologyNode)object);
                Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.createBPAs() mapping BPA " + string2 + " to " + networkTopologyNodeArray[n2].getAttribute("interface")));
                continue block3;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- NetworkTopology.createBPAs() created " + arrayList.size() + " frames (BPAs)"));
    }

    private static String buildMTMS(String string, String string2) {
        return (string == null ? "????-???" : string) + "*" + (string2 == null ? "???????" : string2);
    }

    private static String buildMTMS(String string, String string2, String string3) {
        String string4 = (string == null ? "????" : string) + "-" + (string2 == null ? "???" : string2);
        return NetworkTopology.buildMTMS(string4, string3);
    }

    private static String trimQuotes(String string) {
        int n;
        while ((n = string.indexOf("\"")) > -1) {
            string = string.substring(0, n) + string.substring(++n);
        }
        return string.trim();
    }

    private static String trimBraces(String string) {
        if ((string = string.trim()).startsWith("{")) {
            string = string.substring(1);
        }
        if (string.endsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        return string.trim();
    }

    private static String convertState(String string) {
        String string2;
        Trace.trace((String)TRACE_MASKT, (Object)("-> NetworkTopology.convertState() converting " + string));
        if (CEC_BUNDLE_MAP == null) {
            CEC_BUNDLE_MAP = new HashMap();
        }
        if ((string2 = (String)CEC_BUNDLE_MAP.get(string)) == null) {
            try {
                if (US_CEC_BUNDLE == null) {
                    US_CEC_BUNDLE = ResourceBundle.getBundle(CEC_BUNDLE_NAME, Locale.US);
                }
                Enumeration<String> enumeration = US_CEC_BUNDLE.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string3 = enumeration.nextElement();
                    String string4 = US_CEC_BUNDLE.getString(string3);
                    if (!string4.equals(string)) continue;
                    string2 = string3;
                    CEC_BUNDLE_MAP.put(string4, string3);
                    break;
                }
            }
            catch (MissingResourceException missingResourceException) {
                Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.convertState() caught MissingResourceException: " + missingResourceException));
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- NetworkTopology.convertState() returning " + string2));
        return string2;
    }

    static boolean ping(String string, int n, int n2, String string2, StringBuffer stringBuffer) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> NetworkTopology.ping() pinging " + string + " on adapter " + string2));
        int n3 = -1;
        try {
            String string3;
            StringBuffer stringBuffer2 = null;
            String string4 = "/bin/ping -c " + n2 + " -w " + n + " ";
            if (stringBuffer == null) {
                string4 = string4 + "-q ";
            } else {
                stringBuffer2 = new StringBuffer();
            }
            n3 = string2 == null || string2.trim().length() == 0 ? NetworkTopology.executeCommand(string4 + string, stringBuffer, stringBuffer2) : NetworkTopology.executeCommand(string4 + "-I " + string2 + " " + string, stringBuffer, stringBuffer2);
            if (stringBuffer2 != null && (string3 = stringBuffer2.toString().trim()).length() > 0) {
                stringBuffer.setLength(0);
                stringBuffer.append(string3);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- NetworkTopology.ping() ping returned rc " + n3));
        return n3 == 0;
    }

    private static boolean macAddressesMatch(String string, String string2, String string3) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> NetworkTopology.macAddressesMatch() checking arp to see if " + string2 + " has MAC addr " + string));
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            NetworkTopology.executeCommand(ARP_CMD + string3 + " " + string2, stringBuffer);
        }
        catch (IOException iOException) {
            Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopology.macAddressesMatch() failed trying to run arp command " + iOException.toString()));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n");
        if (stringTokenizer.countTokens() > 1) {
            stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken());
            if (stringTokenizer2.countTokens() > 2) {
                stringTokenizer2.nextToken();
                stringTokenizer2.nextToken();
                String string4 = stringTokenizer2.nextToken().trim();
                string = string.trim();
                bl = string4.equals(string);
                if (!bl && string.length() == 12 && string4.length() == 17) {
                    bl = string4.regionMatches(0, string, 0, 2) && string4.regionMatches(3, string, 2, 2) && string4.regionMatches(6, string, 4, 2) && string4.regionMatches(9, string, 6, 2) && string4.regionMatches(12, string, 8, 2) && string4.regionMatches(15, string, 10, 2);
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- NetworkTopology.macAddressesMatch() returning " + bl));
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class HostInfo {
        public String id = null;
        public String hostName = "unknown";
        private ArrayList ipAddrs = new ArrayList();
        private ArrayList statuses = new ArrayList();

        private HostInfo() {
        }

        public void addAddress(String string) {
            this.ipAddrs.add(string);
            this.statuses.add(null);
        }

        public String getAddress(int n) {
            return (String)this.ipAddrs.get(n);
        }

        public int numAddresses() {
            return this.ipAddrs.size();
        }

        public void setStatus(String string, String string2) {
            for (int i = 0; i < this.ipAddrs.size(); ++i) {
                if (!string.equals(this.getAddress(i))) continue;
                this.statuses.set(i, string2);
                return;
            }
            this.ipAddrs.add(string);
            this.statuses.add(string2);
        }

        public boolean getStatus(String string) {
            for (int i = 0; i < this.ipAddrs.size(); ++i) {
                if (!string.equals(this.getAddress(i))) continue;
                String string2 = (String)this.statuses.get(i);
                return string2 != null && string2.equals(NetworkTopology.FSP_ENCLOSURE_NUMBER);
            }
            return false;
        }
    }

    private static class EventThread
    extends Thread {
        private boolean keepRunning = true;
        private LinkedList eventQueue = new LinkedList();
        private NetworkTopologyListener listener = null;

        public EventThread(NetworkTopologyListener networkTopologyListener) {
            super("NetworkTopology-EventThread");
            this.listener = networkTopologyListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.keepRunning) {
                NetworkTopologyEvent networkTopologyEvent = null;
                EventThread eventThread = this;
                synchronized (eventThread) {
                    while (this.eventQueue.size() == 0 && this.keepRunning) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.eventQueue.size() > 0) {
                        networkTopologyEvent = (NetworkTopologyEvent)this.eventQueue.removeFirst();
                    }
                }
                if (networkTopologyEvent == null) continue;
                this.listener.topologyChanged(networkTopologyEvent);
            }
            while (this.eventQueue.size() > 0) {
                this.listener.topologyChanged((NetworkTopologyEvent)this.eventQueue.removeFirst());
            }
        }

        public synchronized void add(NetworkTopologyEvent networkTopologyEvent) {
            if (this.keepRunning) {
                this.eventQueue.add(networkTopologyEvent);
                this.notify();
            }
        }

        public synchronized void stopRunning() {
            this.keepRunning = false;
            this.notify();
        }
    }

    private static class CumulativeStatus {
        private boolean allOK = true;
        private boolean anyOK = false;

        private CumulativeStatus() {
        }

        public void collectChildrenStatus(NetworkTopologyNode networkTopologyNode, boolean bl) {
            NetworkTopologyNode[] networkTopologyNodeArray = networkTopologyNode.getChildren();
            if (networkTopologyNodeArray != null) {
                for (int i = 0; i < networkTopologyNodeArray.length; ++i) {
                    NetworkTopologyNode networkTopologyNode2 = networkTopologyNodeArray[i];
                    boolean bl2 = networkTopologyNode2.getEvaluatedStatus() == 0;
                    this.allOK = this.allOK && bl2;
                    boolean bl3 = this.anyOK = this.anyOK || bl2;
                    if (!bl) continue;
                    this.collectChildrenStatus(networkTopologyNode2, true);
                }
            }
        }

        public String getCumulativeStatusString() {
            return this.allOK ? "all_nodes_ok" : (this.anyOK ? "some_nodes_failed" : "all_nodes_failed");
        }
    }
}

